//============================================================================
// Weather Shield for Weather Station Data Logger  
// 
//
//This application is free software; you can redistribute it and/or
//modify it under the terms of the GNU Lesser General Public
//License as published by the Free Software Foundation; either
//version 3 of the License, or (at your option) any later version.
//
//This application is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR When PARTICULAR PURPOSE. See the GNU
//Lesser General Public License for more details.
//
//You should have received a copy of the GNU Lesser General Public
//License along with this library; if not, see <http://www.gnu.org/licenses/>
//
//=============================================================================


#ifndef WxReceiverConfig_h
#define WxRecieverConfig_h

//
// set this macro as follows to select the weather shield being used:
// 1 = hand-built shield using the SparkFun RX3400 receiver
// 2 = shield with custom PC board using the Freescale MC33596 receiver
// This macro must be set to the same value in three different files which should
// all include this header file:
// A) The .pde sketch file which imports this library
// B) This file
// C) The wxrx.c file in the utility sub-directory of this library.
// Failure to set the same version in both library files will cause compiler errors.
// A mis-match between macro values in the sketch and library files might
// not cause compiler errors -- but the resulting sketch will not function properly.
//

#define WX_SHIELD_VERSION 2

//
// Set this to a non-zero value to enable detection of pulse spacing modulation (PSM)
// used by AcuRite and some OS wireless sensors.
//

#define DETECT_PSM 1

#endif
