//============================================================================
//Weather Station Data Logger : Weather Shield for Arduino
//Copyright  2010, Weber Anderson
// 
//This application is free software; you can redistribute it and/or
//modify it under the terms of the GNU Lesser General Public
//License as published by the Free Software Foundation; either
//version 3 of the License, or (at your option) any later version.
//
//This application is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR When PARTICULAR PURPOSE. See the GNU
//Lesser General Public License for more details.
//
//You should have received a copy of the GNU Lesser General Public
//License along with this library; if not, see <http://www.gnu.org/licenses/>
//
//=============================================================================


//
// Hardware connections and notes:
//
// The Bosch BMP180 sensor is I2C compliant and should be connected directly
// to the normal SCL and SDA pins. 
//

#ifndef Bmp180_h
#define Bmp180_h

#include "Arduino.h"

class BoschBmp180
{
public:
  BoschBmp180();
  ~BoschBmp180();

  // void reset();
  void init();
  void start();
  void step();
  void waitForPause();

  byte initialized();

  boolean       calDataAvailable();
  byte          getCalData(int* buffer, byte length);
  void          startMeasurement();
  boolean       dataAvailable();
  boolean       getRawData(unsigned long* temp, unsigned long* press, unsigned int* avgCount);
  void          setupAveraging(byte overSamplingMode, unsigned int averagingCount, unsigned long sampleInterval);

private:
  byte			twi_initialized;
  byte          prev_stat;
  byte          failmsg;
  byte          eoc_pin;
  byte          rst_pin;
  byte			status;

  byte          state;
  byte          cal_data_reg;   // EEPROM register currently being read
  boolean       cal_data_available;
  byte          meas_data_reg;  // data register being read
  boolean       data_available; // indicates scp measurement is complete
  boolean       meas_rqst;      // requests scp state machine to start a measurement
  byte          oss_mode;       // 0, 1, 2 or 3
  byte          oss_rqst;       // formatted for the meas request register to save time
  unsigned int  avg_count;      // counter for averaging multiple readings
  unsigned long pval;           // pressure value being built up from individual bytes
  unsigned long tval;           // temperature value being built up from...
  unsigned long pressure;       // running sum of pressure readings 
  unsigned long temperature;    // running sum of temperature readings
  unsigned long delay_timeout;  // used to insert delays in state machine behavior
  unsigned long avg_interval;   // time between readings when averaging (milliseconds)
  unsigned long next_reading;   // millis() time for the next reading while averaging
  int           read_failures;  // used to recover failed measurement requests 
  // unsigned long clock_rate;     // Typically, 400kHz
  unsigned int  navg;           // how many readings to average per output reading
  int           *cal_data;      // 11-element array for EEPROM data
};

extern BoschBmp180 Bmp180;

#endif

