//============================================================================
//Weather Station Data Logger : Weather Shield for Arduino
//Copyright  2010, Weber Anderson
// 
//This application is free software; you can redistribute it and/or
//modify it under the terms of the GNU Lesser General Public
//License as published by the Free Software Foundation; either
//version 3 of the License, or (at your option) any later version.
//
//This application is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR When PARTICULAR PURPOSE. See the GNU
//Lesser General Public License for more details.
//
//You should have received a copy of the GNU Lesser General Public
//License along with this library; if not, see <http://www.gnu.org/licenses/>
//
//=============================================================================

#ifndef sht1x_h
#define sht1x_h

#define MILLIS_CMP(a,b) ( (a==b) ? 0 : ( (a>b) ? (((a-b)>mm_diff) ? -1 : 1) : (((b-a)>mm_diff) ? 1 : -1) ) )

#define DEFAULT_SHT1X_DATA_PIN 7  
#define DEFAULT_SHT1X_CLK_PIN  6 
//
// to avoid damage to the SHT1x sensor,
// the DATA pin can only be driven low as an output. if we want to send a "HIGH"
// output, it must be done by setting the data pin as INPUT with the pull-up enabled.
// to accomplish this, the following sequences must be followed:
// 
// to go from high output or input mode to a low output:
// first set the output pin low. this disables the pull-up resistor which is not 
// necessarily desired, but it is necessary to preset the
// output pin to the low state. then, change the pin from input to output.
//
// to go from low output to high output or input mode, first change the pin to
// an input, then set the pin to high, enabling the pull-up resistor.
//
// as mentioned above, if a 10k pull-up resistor is added to the data line,
// this gets a lot simpler. just initialize the port data bit to zero and leave
// it there. Then data_low() is just switching the port bit to output mode, and
// data_high() is simply switching to input mode.
//

#define SHT1X_DATA_SETUP_US 20
#define SHT1X_DATA_LOW  { noInterrupts(); digitalWrite(sht1x_data_pin, LOW); pinMode(sht1x_data_pin, OUTPUT); interrupts(); delayMicroseconds(SHT1X_DATA_SETUP_US); }
#define SHT1X_DATA_HIGH { noInterrupts(); pinMode(sht1x_data_pin, INPUT); digitalWrite(sht1x_data_pin, HIGH); interrupts(); delayMicroseconds(SHT1X_DATA_SETUP_US); }

#define SHT1X_DATA_HOLD_US 20
#define SHT1X_CLOCK_HIGH { noInterrupts(); digitalWrite(sht1x_clock_pin, HIGH); interrupts(); delayMicroseconds(SHT1X_DATA_HOLD_US); }
#define SHT1X_CLOCK_LOW  { noInterrupts(); digitalWrite(sht1x_clock_pin, LOW ); interrupts(); delayMicroseconds(SHT1X_DATA_HOLD_US); }

#define CRC_ERROR_RESET_THRESHOLD 100

// these cmd defs also include the 3 address bits which are always equal to zero
#define SHT1X_MEAS_TEMP_CMD 0x03
#define SHT1X_MEAS_RH_CMD   0x05

#define SHT1X_STATE_INIT        0
#define SHT1X_STATE_IDLE        1
#define SHT1X_STATE_READ_TEMP   2
#define SHT1X_STATE_WAIT        3
#define SHT1X_STATE_READ_RH     4
#define SHT1X_STATE_FAIL        5

#endif
