//============================================================================
// Weather Shield for Weather Station Data Logger  
// 
//
//This application is free software; you can redistribute it and/or
//modify it under the terms of the GNU Lesser General Public
//License as published by the Free Software Foundation; either
//version 3 of the License, or (at your option) any later version.
//
//This application is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR When PARTICULAR PURPOSE. See the GNU
//Lesser General Public License for more details.
//
//You should have received a copy of the GNU Lesser General Public
//License along with this library; if not, see <http://www.gnu.org/licenses/>
//
//=============================================================================


#ifndef WxReceiverConfig_h
#define WxRecieverConfig_h

//
// set this macro as follows to select the weather shield being used:
// 1 = hand-built shield using the SparkFun RX3400 receiver
// 2 = shield with custom PC board using the Freescale MC33596 receiver
//

#define WX_SHIELD_VERSION 2

//
// =================== do not make changes below this line =======================
//

#define PROTOCOL_UNKNOWN         0
#define PROTOCOL_OS1             1
#define PROTOCOL_OS2             2
#define PROTOCOL_OS3             3
#define PROTOCOL_PSM            16
#define PROTOCOL_VN1TX          17
#define PROTOCOL_WH2B           18
#define PROTOCOL_F007TH         19
#define PROTOCOL_WXSENSOR       23

#define PROTOCOL_IS_OS(x)       ((x >= 1) && (x <= 15))

#endif
