//============================================================================
// Weather Shield for Weather Station Data Logger  
// 
//
//This application is free software; you can redistribute it and/or
//modify it under the terms of the GNU Lesser General Public
//License as published by the Free Software Foundation; either
//version 3 of the License, or (at your option) any later version.
//
//This application is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR When PARTICULAR PURPOSE. See the GNU
//Lesser General Public License for more details.
//
//You should have received a copy of the GNU Lesser General Public
//License along with this library; if not, see <http://www.gnu.org/licenses/>
//
//=============================================================================
//
// WxReceivers is the Arduino library class that provides support for
// two (as of now) different weather shields for WSDL: 
// 1. The hand-built shiled using the SparkFun RX3400 receiver.
// 2. The shield with custom PC board using the Freescale MC33596 receiver.
//
// Hardware connections and notes:
//

#ifndef WxReceivers_h
#define WxRecievers_h

#include "Arduino.h"

class WxRx
{
public:
  WxRx();

  void init();
  void start();
  void step();
  void pause();
  void resume();

#if 0
  int state();
  unsigned long interruptCounter();
#endif

#if WX_SHIELD_VERSION == 2
  //
  //
  //
  void check_agc_state();
  //
  //
  //
  void request_rssi();
  boolean rssi_available();
  byte rssi_register_value();
  //
  // access to MC33596 status bits
  //
  void request_status();
  boolean status_available();
  byte status_value();
  //
  // only legal values for dB are 0, 8, 16, 30. If other values are passed,
  // false will be returned indicating an invalid argument.
  //
  boolean set_rf_attenuation(int dB);

  unsigned int get_rssi();
  //
  // asynchronously reads the RSSI voltage using the ADC.
  // this is not sync'ed with message bits so reading it while
  // noise is present can be used to calibrate the 
  // RSSI voltage corresponding to the receiver's noise floor.
  //
  unsigned int force_read_rssi(unsigned int average_count);

#endif

  boolean data_available();
  byte get_data(byte *buffer, byte length, byte *protocol);
  void resume_receiving();
  void force_reset();


private:

  boolean running;
  boolean initialized;
  //
  // these used to detect version 2.1 protocol repeated packets
  // so one of them can be discarded
  //
  byte previous_packet[90];
  unsigned long previous_packet_time;

#if WX_SHIELD_VERSION == 2

  unsigned long clock_rate; // SPI interface clock rate in Hz

  boolean reading_rssi;
  byte rssi_register;

  boolean reading_status;
  byte status_register;

  boolean updating_agc;
  boolean agc_frozen;

#endif

  boolean ValidV1Checksum(byte *packet, int Pos);
  boolean ValidChecksum(byte *packet, int Pos);

};

extern WxRx WxReceivers;

#endif
