//============================================================================
//Weather Station Data Logger : Weather Shield for Arduino
//Copyright  2010, Weber Anderson
// 
//This application is free software; you can redistribute it and/or
//modify it under the terms of the GNU Lesser General Public
//License as published by the Free Software Foundation; either
//version 3 of the License, or (at your option) any later version.
//
//This application is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR When PARTICULAR PURPOSE. See the GNU
//Lesser General Public License for more details.
//
//You should have received a copy of the GNU Lesser General Public
//License along with this library; if not, see <http://www.gnu.org/licenses/>
//
//=============================================================================

#ifndef bmp_h
#define bmp_h


// BMP085 I2C address is hard-coded inside the chip and cannot be changed.
#define BMP_ADDR ((uint8_t)0x77)

#define DEFAULT_EOC_PIN 17  /* ADC 3 */
#define DEFAULT_RST_PIN  8  /* D8 */

// register definitions

#define BMP_CHIP_ID     ((uint8_t)0xD0)
#define BMP_VERSION     ((uint8_t)0xD1)
#define BMP_CAL_START   ((uint8_t)0xAA)
#define BMP_CAL_END     ((uint8_t)0xBF)
#define BMP_MEAS_RQST   ((uint8_t)0xF4)
#define BMP_DATA_MSB    ((uint8_t)0xF6)
#define BMP_DATA_LSB    ((uint8_t)0xF7)
#define BMP_DATA_XLSB   ((uint8_t)0xF8)

#define BMP_MEAS_TEMP   ((uint8_t)0x2E)
#define BMP_MEAS_PRESS  ((uint8_t)0x34)

#define BMP_OSS_MODE(oss)   (BMP_MEAS_PRESS | (uint8_t)(oss << 6))

#define CAL_DATA_LENGTH ((BMP_CAL_END - BMP_CAL_START + 1) >> 1)

#define BMP_ID_CODE     ((uint8_t)0x55)

#define STATE_INIT        0x00 /* power-up initialization -- we have not talked to it yet */
#define STATE_ID_CHECK    0x01 /* init is finished, ready to check ID code */
#define STATE_READ_CAL    0x02 /* reading calibration data from EEPROM inside the sensor */
#define STATE_IDLE        0x03 /* configured and ready for measurement to be initiated */
#define STATE_MEAS_TEMP   0x04 /* measuring temperature, waiting for the data ready flag */
#define STATE_READ_TEMP   0x05
#define STATE_MEAS_PRESS  0x06
#define STATE_READ_PRESS  0x07
#define STATE_WAIT_NEXT   0x08
#define STATE_FAIL        0x09


#endif
